---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：9-Extension Bisect Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **推定再起動回数の計算式詳細**：ログ計算の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - BisectState (行44-65)
- E-02: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - IExtensionBisectService (行32-42)
- E-03: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - ExtensionBisectService (行67-162)
- E-04: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - _storageKey (行71)
- E-05: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - isDisabledByBisect() (行102-117)
- E-06: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - start() (行123-131)
- E-07: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - next() (行133-156)
- E-08: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - reset() (行158-161)
- E-09: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - ExtensionBisectUi (行168-210)
- E-10: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - _showBisectPrompt() (行184-208)
- E-11: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - StartBisect Action (行217-254)
- E-12: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - ContinueBisect Action (行256-350)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ストレージキーはextensionBisectState | E-04 | ○ |
| C-02 | StorageScope.APPLICATIONで保存 | E-06 (行129) | ○ |
| C-03 | BisectStateにextensions配列 | E-01 (行60) | ○ |
| C-04 | BisectStateにlow/high/mid | E-01 (行61-63) | ○ |
| C-05 | mid = (low + high) / 2 \| 0 | E-01 (行63) | ○ |
| C-06 | disabledCount = high - mid | E-03 (行98-99) | ○ |
| C-07 | isDisabledByBisectで無効化判定 | E-05 | ○ |
| C-08 | Remote Resolver除外 | E-05 (行107-109) | ○ |
| C-09 | --enable-extensions除外 | E-05 (行110-113) | ○ |
| C-10 | start()で状態初期化 | E-06 | ○ |
| C-11 | next()で探索進行 | E-07 | ○ |
| C-12 | seeingBadでlow/high更新 | E-07 (行148-152) | ○ |
| C-13 | low === high - 1で完了判定 | E-07 (行142-145) | ○ |
| C-14 | mid === 0 && high === lengthでVS Code問題 | E-07 (行138-140) | ○ |
| C-15 | reset()で状態クリア | E-08 | ○ |
| C-16 | ctxIsBisectActiveコンテキスト | E-09 (行170) | ○ |
| C-17 | 単数メッセージ | E-10 (行199-200) | ○ |
| C-18 | 複数メッセージ | E-10 (行201) | ○ |
| C-19 | "I can't reproduce"でnext(false) | E-10 (行186-188) | ○ |
| C-20 | "I can reproduce"でnext(true) | E-10 (行190-192) | ○ |
| C-21 | "Stop Bisect"でreset | E-10 (行194-196) | ○ |
| C-22 | 開始時に確認ダイアログ | E-11 (行243-247) | ○ |
| C-23 | 推定再起動回数表示 | E-11 (行245: 2 + Math.log2) | ○ |
| C-24 | 特定成功時にReport Issueオプション | E-12 (行305-317) | ○ |
| C-25 | "Keep disabled"チェックボックス | E-12 (行311) | ○ |
| C-26 | 推定再起動回数の詳細計算 | E-11 (行245) | △ |

## 4) 不足情報（Unknown / Missing）
- 推定再起動回数の詳細計算（2 + Math.log2(extensions.length) | 0）について、切り捨ての確認が必要
  - 候補：実際の動作確認 / 単体テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BisectState構造（E-01に基づく）
- 0: 低リスク - 二分探索ロジック（E-07に基づく）
- 0: 低リスク - UI通知（E-09, E-10に基づく）
- 1: 中リスク - 推定再起動回数の計算詳細

## 6) レビュアーチェックリスト（最小）
- [ ] BisectStateの構造が正しいか
- [ ] 二分探索の条件分岐が正しいか（seeingBadによる範囲更新）
- [ ] 除外条件（Remote Resolver、--enable-extensions）が正しいか
- [ ] 通知メッセージの単数/複数形が正しいか
- [ ] Issue Reporter連携の処理が正しいか
